/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.jail;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.jail.JailLocation;
import de.dustplanet.passwordprotect.utils.PasswordProtectUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING", "CD_CIRCULAR_DEPENDENCY"})
public class JailHelper {
    private static final int SLOWNESS_AMPLIFIER = 5;
    private static final int DARKNESS_AMPLIFIER = 15;
    private static final int DEFAULT_RADIUS = 4;
    private static final int TWENTY_FOUR_HOURS_IN_TICKS = 1728000;
    private final Map<World, JailLocation> jailLocations = new HashMap<World, JailLocation>();
    private final FileConfiguration jails;
    private final File jailFile;
    private final PasswordProtect plugin;
    private final PasswordProtectUtilities utils;
    private Map<UUID, Integer> jailedPlayers = new HashMap<UUID, Integer>();
    private final Map<UUID, Location> playerLocations = new HashMap<UUID, Location>();

    public JailHelper(PasswordProtect instance, File jailFile, FileConfiguration jails) {
        this.plugin = instance;
        this.jailFile = jailFile;
        this.jails = jails;
        this.utils = instance.getUtils();
    }

    public void clear() {
        this.getJailedPlayers().clear();
        this.getJailLocations().clear();
        this.getPlayerLocations().clear();
    }

    @SuppressFBWarnings(value={"OPM_OVERLY_PERMISSIVE_METHOD"})
    public void setJailLocation(World world, JailLocation location) {
        this.jailLocations.put(world, location);
        ArrayList<Double> data = new ArrayList<Double>();
        data.add(location.getX());
        data.add(location.getY());
        data.add(location.getZ());
        data.add(Double.valueOf(location.getYaw()));
        data.add(Double.valueOf(location.getPitch()));
        data.add(Double.valueOf(location.getRadius()));
        String worldName = world.getName();
        this.jails.set(worldName + ".jailLocation", data);
        this.saveJails();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private JailLocation getJailLocation(Player player) {
        World world = player.getWorld();
        JailLocation jailLocation = this.jailLocations.get(world);
        if (jailLocation == null) {
            jailLocation = this.loadJailLocation(world);
            Location spawnLocation = world.getSpawnLocation();
            if (jailLocation == null) {
                jailLocation = new JailLocation(world, spawnLocation.getX(), spawnLocation.getWorld().getHighestBlockYAt(spawnLocation.getBlockX(), spawnLocation.getBlockZ()) + 1, spawnLocation.getZ(), spawnLocation.getYaw(), spawnLocation.getPitch(), 4);
                this.jailLocations.put(world, jailLocation);
                this.setJailLocation(world, jailLocation);
            }
        }
        return jailLocation;
    }

    public void stayInJail(Player player) {
        if (this.plugin.getConfig().getBoolean("disableJailArea", false)) {
            return;
        }
        JailLocation jailLocation = this.getJailLocation(player);
        Location playerLocation = player.getLocation();
        int radius = jailLocation.getRadius();
        if (Math.abs(jailLocation.getBlockX() - playerLocation.getBlockX()) <= radius && Math.abs(jailLocation.getBlockY() - playerLocation.getBlockY()) <= radius && Math.abs(jailLocation.getBlockZ() - playerLocation.getBlockZ()) <= radius) {
            return;
        }
        this.sendToJail(player);
    }

    public void check(Player player) {
        if (!this.utils.isPasswordSet()) {
            if (player.hasPermission("passwordprotect.setpassword")) {
                String messageLocalization = this.plugin.getLocalization().getString("set_password");
                this.utils.message((CommandSender)player, messageLocalization, null);
            }
            return;
        }
        if (this.checkPlayerPermissions(player)) {
            if (this.plugin.getConfig().getBoolean("teleportBack", true) && !this.getPlayerLocations().containsKey(player.getUniqueId())) {
                this.getPlayerLocations().put(player.getUniqueId(), player.getLocation());
            }
            if (!this.plugin.getConfig().getBoolean("disableJailArea", false)) {
                this.sendToJail(player);
            }
            if (!this.getJailedPlayers().containsKey(player.getUniqueId())) {
                this.getJailedPlayers().put(player.getUniqueId(), 1);
            }
            if (this.plugin.getConfig().getBoolean("prevent.flying", true)) {
                player.setAllowFlight(false);
            }
            if (this.plugin.getConfig().getBoolean("darkness", true)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 1728000, 15));
            }
            if (this.plugin.getConfig().getBoolean("slowness", true)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 1728000, 5));
            }
            this.utils.sendPasswordRequiredMessage(player);
        }
    }

    private boolean checkPlayerPermissions(Player player) {
        if (player.isOp()) {
            return this.plugin.getConfig().getBoolean("opsRequirePassword", true);
        }
        return !player.hasPermission("passwordprotect.nopassword");
    }

    private void sendToJail(Player player) {
        JailLocation jailLocation = this.getJailLocation(player);
        player.teleport((Location)jailLocation);
    }

    @Nullable
    private JailLocation loadJailLocation(World world) {
        String worldName = world.getName();
        List data = this.jails.getDoubleList(worldName + ".jailLocation");
        if (data.size() != 6) {
            return null;
        }
        double x = (Double)data.get(0);
        double y = (Double)data.get(1);
        double z = (Double)data.get(2);
        float yaw = ((Double)data.get(3)).floatValue();
        float pitch = ((Double)data.get(4)).floatValue();
        int radius = ((Double)data.get(5)).intValue();
        return new JailLocation(world, x, y, z, yaw, pitch, radius);
    }

    private void saveJails() {
        try {
            this.jails.save(this.jailFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save the jails.yml!", e);
        }
    }

    public Map<World, JailLocation> getJailLocations() {
        return this.jailLocations;
    }

    public Map<UUID, Integer> getJailedPlayers() {
        return this.jailedPlayers;
    }

    public void setJailedPlayers(Map<UUID, Integer> jailedPlayers) {
        this.jailedPlayers = jailedPlayers;
    }

    public Map<UUID, Location> getPlayerLocations() {
        return this.playerLocations;
    }
}

